/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BlocksCanvas
extends Canvas
implements Runnable {
    static final int MINIMUMSCROLLDELAY = 150;
    static int level = 1;
    Random random = new Random();
    private int initTime;
    private int timeleft;
    private int extraTime = 0;
    private int elapsedTime = 0;
    private int scores = 0;
    private Blocks parent;
    private boolean gameOver = false;
    private static final int ROWS = 7;
    private static final int COLS = 7;
    private static final int MIDDLE = 3;
    private int[][] board = new int[7][7];
    private int width;
    private int height;
    private int p1top;
    private int p2top;
    private int pleft;
    private int p1height;
    private int bsize = 20;
    private int GAP;
    private int cellW;
    private int cellH;
    private int bgcolor = 255;
    private int blockcolor = 127;
    private int pencolor = 0;
    Graphics bg;
    Image buf;
    Font fcal;
    int state;
    int fontH;
    int fontW;
    int fontW2;
    int waitblock = 0;
    int direct = 0;
    int mblock_x;
    int mblock_y;
    static int count = 0;
    int remains;
    int fallen;
    private static final int maxblocks = 6;
    Image[] imgs = new Image[6];
    boolean[] left = new boolean[6];
    Thread runner;

    public BlocksCanvas(Blocks creator) {
        this.parent = creator;
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.buf = Image.createImage((int)this.width, (int)this.height);
        this.bg = this.buf.getGraphics();
        this.fcal = Font.getFont((int)0, (int)0, (int)8);
        this.fontH = this.fcal.getHeight();
        this.fontW2 = this.fcal.stringWidth(" Game Over ");
        try {
            if (this.width < 120) {
                this.imgs[0] = Image.createImage((String)"/pics/a10.png");
                this.imgs[1] = Image.createImage((String)"/pics/b10.png");
                this.imgs[2] = Image.createImage((String)"/pics/c10.png");
                this.imgs[3] = Image.createImage((String)"/pics/j10.png");
                this.imgs[4] = Image.createImage((String)"/pics/k10.png");
                this.imgs[5] = Image.createImage((String)"/pics/n10.png");
                this.cellW = 10;
                this.bsize = 10;
                this.p1height = this.cellW + 4;
                this.GAP = 1;
            } else {
                this.imgs[0] = Image.createImage((String)"/pics/a20.png");
                this.imgs[1] = Image.createImage((String)"/pics/b20.png");
                this.imgs[2] = Image.createImage((String)"/pics/c20.png");
                this.imgs[3] = Image.createImage((String)"/pics/j20.png");
                this.imgs[4] = Image.createImage((String)"/pics/k20.png");
                this.imgs[5] = Image.createImage((String)"/pics/n20.png");
                this.cellW = 20;
                this.bsize = 20;
                this.p1height = this.cellW + 4;
                this.GAP = 3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.p1top = 0;
        this.p2top = this.p1top + this.p1height + 2 * this.GAP;
        this.pleft = (this.width - this.bsize * 7 - 6 * this.GAP) / 2;
        this.reset();
    }

    public void reset() {
        this.initTime = 99000 - (level - 1) * 2000;
        if (this.initTime < 89000) {
            this.initTime = 80000;
        }
        this.timeleft = this.initTime;
        this.state = 1;
        this.direct = 0;
        int i = 0;
        while (i < 6) {
            this.left[i] = false;
            ++i;
        }
        this.initBoard();
        this.mblock_x = 3;
        this.mblock_y = 0;
    }

    public void initBoard() {
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                if (i <= 2) {
                    this.board[i][j] = 0;
                } else {
                    boolean cont = true;
                    while (cont) {
                        cont = false;
                        this.board[i][j] = (this.random.nextInt() >>> 1) % 6 + 1;
                        if (j != 0) {
                            if (this.board[i][j] != this.board[i][j - 1] && this.board[i][j] != this.board[i - 1][j]) continue;
                            cont = true;
                            continue;
                        }
                        if (this.board[i][j] != this.board[i - 1][j]) continue;
                        cont = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.board[0][3] = (this.random.nextInt() >>> 1) % 6 + 1;
        this.waitblock = (this.random.nextInt() >>> 1) % 6 + 1;
        this.bg.setGrayScale(this.bgcolor);
        this.bg.fillRect(0, 0, this.width, this.height);
        int i2 = 0;
        while (i2 < 7) {
            int j = 0;
            while (j < 7) {
                if (this.board[i2][j] != 0) {
                    int x = this.getLeft(j);
                    int y = this.getTop(i2);
                    int ii = this.board[i2][j] - 1;
                    this.bg.drawImage(this.imgs[ii], x, y, 0x10 | 4);
                }
                ++j;
            }
            ++i2;
        }
        this.drawWaitblock(this.waitblock);
        this.remains = 28;
        this.fallen = 0;
    }

    private int getTop(int x) {
        int i = 0;
        i = this.p2top + this.bsize * x + x * this.GAP;
        return i;
    }

    private int getLeft(int x) {
        int i = 0;
        i = x > 0 ? this.pleft + this.bsize * x + x * this.GAP : this.pleft + this.bsize * x;
        return i;
    }

    public void run() {
        long nextTime = 0L;
        long stopTime = 0L;
        int minus_time = 0;
        boolean trigger = true;
        boolean xswitch = true;
        if (this.gameOver) {
            this.bg.drawString("GAME OVER", this.width / 2, this.height / 2, 0x10 | 1);
        } else {
            this.paintTime();
        }
        while (!this.gameOver) {
            long timeNow = System.currentTimeMillis();
            if (trigger) {
                stopTime = timeNow;
                trigger = false;
            }
            this.elapsedTime += 150;
            this.timeleft = this.initTime - this.elapsedTime + this.extraTime;
            if (nextTime < timeNow + 150L) {
                nextTime = timeNow + 150L;
            }
            try {
                Thread.sleep(nextTime - timeNow);
            }
            catch (Exception e) {
                // empty catch block
            }
            nextTime = System.currentTimeMillis() + 150L;
            switch (this.state) {
                case 1: {
                    int ii;
                    int y;
                    int x;
                    this.paintTime();
                    minus_time = Math.min(1000, this.fallen * 4);
                    if (this.direct != 2 && nextTime - 150L - stopTime > (long)(4000 - minus_time)) {
                        if (xswitch) {
                            x = this.getLeft(this.mblock_x);
                            y = this.getTop(0);
                            this.bg.setGrayScale(this.bgcolor);
                            this.bg.fillRect(x, y, this.bsize, this.bsize);
                            xswitch = false;
                        } else {
                            x = this.getLeft(this.mblock_x);
                            y = this.getTop(0);
                            ii = this.board[0][this.mblock_x] - 1;
                            this.bg.drawImage(this.imgs[ii], x, y, 0x10 | 4);
                            xswitch = true;
                        }
                        if (nextTime - 150L - stopTime > (long)(7500 - (minus_time += Math.min(1000, level * 150)))) {
                            stopTime = nextTime;
                            this.direct = 2;
                        }
                    }
                    if (this.direct != 0) {
                        int temp_x;
                        if (this.direct == 1) {
                            temp_x = this.mblock_x - 1;
                            if (temp_x <= -1) {
                                temp_x = 6;
                            }
                            this.moveBlock(this.mblock_x, 0, temp_x, 0, this.board[0][this.mblock_x]);
                            this.mblock_x = temp_x;
                            this.direct = 0;
                        } else if (this.direct == 2) {
                            stopTime = 0L;
                            int temp_y = this.mblock_y + 1;
                            if (temp_y <= 6 && this.board[temp_y][this.mblock_x] == 0) {
                                this.moveBlock(this.mblock_x, this.mblock_y, this.mblock_x, temp_y, this.board[this.mblock_y][this.mblock_x]);
                                this.mblock_y = temp_y;
                            } else {
                                ++this.remains;
                                ++this.fallen;
                                this.scores += 10;
                                this.findconnect(this.mblock_x, this.mblock_y, this.board[this.mblock_y][this.mblock_x]);
                                if (count >= 2) {
                                    this.remove();
                                    this.paintTime();
                                    this.rearrange();
                                    this.reverse();
                                    this.extraTime += (count - 1) * 2000;
                                    this.scores += (count - 1) * 20;
                                    int i = 6;
                                    while (i >= 1) {
                                        int j = 0;
                                        while (j < 7) {
                                            count = 0;
                                            if (this.board[i][j] != 0) {
                                                this.findconnect(j, i, this.board[i][j]);
                                                if (count >= 2) {
                                                    this.remove();
                                                    this.rearrange();
                                                    this.reverse();
                                                    this.extraTime += (count - 1) * 2000;
                                                    this.scores += (count - 1) * 20;
                                                    count = 0;
                                                    break;
                                                }
                                                this.reverse();
                                            }
                                            ++j;
                                        }
                                        --i;
                                    }
                                }
                                this.reverse();
                                this.paintTime();
                                if (!this.isGameover()) {
                                    if (this.fallen % 32 == 0) {
                                        this.raiseBlocks();
                                    }
                                    int i = 0;
                                    while (i < 7) {
                                        if (this.board[0][i] != 0) {
                                            this.state = 4;
                                        }
                                        ++i;
                                    }
                                    if (this.state != 4) {
                                        int temp = (this.random.nextInt() >>> 1) % 6 + 1;
                                        if (this.remains < 15) {
                                            int i2 = 0;
                                            while (i2 < 6) {
                                                this.left[i2] = false;
                                                ++i2;
                                            }
                                            int i3 = 1;
                                            while (i3 < 7) {
                                                int j = 0;
                                                while (j < 7) {
                                                    if (this.board[i3][j] == 1) {
                                                        this.left[0] = true;
                                                    } else if (this.board[i3][j] == 2) {
                                                        this.left[1] = true;
                                                    } else if (this.board[i3][j] == 3) {
                                                        this.left[2] = true;
                                                    } else if (this.board[i3][j] == 4) {
                                                        this.left[3] = true;
                                                    } else if (this.board[i3][j] == 5) {
                                                        this.left[4] = true;
                                                    } else if (this.board[i3][j] == 6) {
                                                        this.left[5] = true;
                                                    }
                                                    ++j;
                                                }
                                                ++i3;
                                            }
                                            if (this.left[0] || this.left[1] || this.left[2] || this.left[3] || this.left[4] || this.left[5]) {
                                                while (!this.left[temp - 1]) {
                                                    temp = (this.random.nextInt() >>> 1) % 6 + 1;
                                                }
                                            }
                                        }
                                        this.board[0][3] = this.waitblock;
                                        x = this.getLeft(3);
                                        y = this.getTop(0);
                                        ii = this.board[0][3] - 1;
                                        this.bg.drawImage(this.imgs[ii], x, y, 0x10 | 4);
                                        this.mblock_x = 3;
                                        this.mblock_y = 0;
                                        this.waitblock = temp;
                                        this.drawWaitblock(temp);
                                    }
                                }
                                count = 0;
                                this.direct = 0;
                                trigger = true;
                            }
                        } else if (this.direct == 3) {
                            temp_x = this.mblock_x + 1;
                            if (temp_x >= 7) {
                                temp_x = 0;
                            }
                            this.moveBlock(this.mblock_x, 0, temp_x, 0, this.board[0][this.mblock_x]);
                            this.mblock_x = temp_x;
                            this.direct = 0;
                        }
                    }
                    if (this.timeleft <= 900) {
                        this.state = 4;
                    }
                    if (this.remains != 0) break;
                    this.state = 5;
                    break;
                }
                case 4: {
                    this.gameover();
                    this.endGame();
                    break;
                }
                case 5: {
                    this.youwin();
                    this.endGame();
                    break;
                }
            }
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.buf, 0, 0, 0x10 | 4);
    }

    private void paintTime() {
        int temp = this.timeleft / 1000;
        this.bg.setGrayScale(this.bgcolor);
        this.bg.fillRect(0, 0, this.width - this.cellW - 2 * this.GAP, this.p1height);
        this.bg.setGrayScale(this.pencolor);
        this.bg.drawString("T: " + temp + " S: " + this.scores + " L:" + level, 1, 1, 0x10 | 4);
    }

    private void drawWaitblock(int val) {
        this.bg.drawImage(this.imgs[val - 1], this.width - this.cellW - 2 * this.GAP, 2, 0x10 | 4);
    }

    private void moveBlock(int from_x, int from_y, int to_x, int to_y, int num) {
        this.clearBlock(from_x, from_y);
        int x = this.getLeft(to_x);
        int y = this.getTop(to_y);
        this.board[to_y][to_x] = num;
        int ii = this.board[to_y][to_x] - 1;
        this.bg.drawImage(this.imgs[ii], x, y, 0x10 | 4);
    }

    private void findconnect(int cx, int cy, int value) {
        this.board[cy][cx] = value * -1;
        if (cx < 6 && cy >= 0 && cy <= 7 && this.board[cy][cx + 1] == value) {
            ++count;
            this.findconnect(cx + 1, cy, value);
        }
        if (cx > 0 && cy >= 0 && cy <= 7 && this.board[cy][cx - 1] == value) {
            ++count;
            this.findconnect(cx - 1, cy, value);
        }
        if (cx >= 0 && cx <= 6 && cy < 6 && this.board[cy + 1][cx] == value) {
            ++count;
            this.findconnect(cx, cy + 1, value);
        }
        if (cx >= 0 && cx <= 6 && cy > 0 && this.board[cy - 1][cx] == value) {
            ++count;
            this.findconnect(cx, cy - 1, value);
        }
    }

    private void reverse() {
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                if (this.board[i][j] < 0) {
                    this.board[i][j] = this.board[i][j] * -1;
                }
                ++j;
            }
            ++i;
        }
    }

    private void remove() {
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                if (this.board[i][j] < 0) {
                    this.board[i][j] = 0;
                    this.clearBlock(j, i);
                    --this.remains;
                }
                ++j;
            }
            ++i;
        }
    }

    private void rearrange() {
        boolean b = true;
        while (b) {
            b = false;
            int i = 5;
            while (i >= 1) {
                int j = 0;
                while (j < 7) {
                    if (this.board[i + 1][j] == 0 && this.board[i][j] != 0) {
                        this.moveBlock(j, i, j, i + 1, this.board[i][j]);
                        b = true;
                    }
                    ++j;
                }
                --i;
            }
        }
    }

    private void clearBlock(int xpos, int ypos) {
        int x = this.getLeft(xpos);
        int y = this.getTop(ypos);
        this.board[ypos][xpos] = 0;
        this.bg.setGrayScale(this.bgcolor);
        this.bg.fillRect(x, y, this.bsize, this.bsize);
    }

    private void raiseBlocks() {
        int j;
        int temp = 1;
        int i = 1;
        while (i < 7) {
            j = 0;
            while (j < 7) {
                if (this.board[i][j] != 0) {
                    this.moveBlock(j, i, j, i - 1, this.board[i][j]);
                }
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < 7) {
            boolean cont = true;
            while (cont) {
                cont = false;
                temp = (this.random.nextInt() >>> 1) % 6 + 1;
                if (j != 0) {
                    if (temp != this.board[6][j - 1] && temp != this.board[5][j]) continue;
                    cont = true;
                    continue;
                }
                if (temp != this.board[5][j]) continue;
                cont = true;
            }
            this.board[6][j] = temp;
            int x = this.getLeft(j);
            int y = this.getTop(6);
            this.bg.drawImage(this.imgs[temp - 1], x, y, 0x10 | 4);
            ++j;
        }
        this.remains += 7;
    }

    private boolean isGameover() {
        return this.gameOver;
    }

    private void gameover() {
        this.bg.setGrayScale(this.bgcolor);
        this.bg.fillRect(this.width / 2 - this.fontW2 / 2, this.height / 2, this.fontW2, this.fontH);
        this.bg.setGrayScale(this.pencolor);
        this.bg.drawString("Game Over", this.width / 2, this.height / 2, 0x10 | 1);
    }

    private void youwin() {
        this.bg.setGrayScale(this.bgcolor);
        this.bg.fillRect(this.width / 2 - this.fontW2 / 2, this.height / 2, this.fontW2, this.fontH);
        this.bg.setGrayScale(this.pencolor);
        this.bg.drawString("You Win", this.width / 2, this.height / 2, 0x10 | 1);
    }

    public void endGame() {
        this.runner = null;
        this.gameOver = true;
    }

    void restartGame() {
        this.timeleft = this.initTime;
        level = this.state == 5 ? ++level : 1;
        this.scores = 0;
        count = 0;
        this.elapsedTime = 0;
        this.extraTime = 0;
        this.bg.setGrayScale(this.bgcolor);
        this.bg.fillRect(0, 0, this.width, this.height);
        this.reset();
        if (this.gameOver) {
            this.gameOver = false;
            this.start();
        }
        this.gameOver = false;
    }

    synchronized void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    synchronized void pause() {
    }

    void dest() {
        this.parent.destroyApp(true);
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void keyPressed(int keyCode) {
        if (this.direct == 0) {
            int action = this.getGameAction(keyCode);
            switch (action) {
                case 2: {
                    this.direct = 1;
                    break;
                }
                case 6: {
                    this.direct = 2;
                    break;
                }
                case 5: {
                    this.direct = 3;
                }
            }
        }
    }
}

